<?xml version="1.0" encoding="UTF-8" ?>
<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib uri="http://jakarta.apache.org/taglibs/bsf-2.0" prefix="bsf" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>Script Tag Library Example</title>
	<link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body>

<h1>Contact List</h1>

<table class="contactlist">
    <thead>
    <tr>
        <th>First Name</th>
        <th>Last Name</th>
        <th>Birthday</th>
        <th>&nbsp;</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
    <tbody>
    <tr><td colspan="5"><hr/></td></tr>
<bsf:scriptlet language="php">
<?php 

# Java classes can be imported 
import java.util.Calendar;


# get list of people from session
$people = $session->getAttribute("personService")->getPeople();

# list the people with buttons for edit and delete
foreach ($people as $person) {
	$out->println(sprintf("<tr><td>%s</td><td>%s</td><td>", $person->firstName, $person->lastName));
	$out->println(sprintf("%s/%s/%s", $person->birthday->get(Calendar::DATE), $person->birthday->get(Calendar::MONTH) + 1, $person->birthday->get(Calendar::YEAR)));
	$out->println(sprintf("</td><td><a href=\"PHPController?target=edit&id=%s\"><img src=\"images/edit.png\" title=\"Edit\"/></a></td>", $person->id));
	$out->println(sprintf("<td><a href=\"PHPController?target=delete&id=%s\"><img src=\"images/delete.png\" title=\"Delete\"/></a></td></tr>", $person->id));
}

?>
</bsf:scriptlet>
</tbody></table>
<br />
<a href="PHPController?target=new">Create New Contact</a>
</body>
</html>